/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.shared.utils.log;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.skinsrestorer.shared.interfaces.ISRLogger;
import net.skinsrestorer.shared.storage.Config;
import net.skinsrestorer.shared.storage.YamlConfig;
import net.skinsrestorer.shared.utils.log.ANSIConverter;
import net.skinsrestorer.shared.utils.log.SRLogLevel;

public class SRLogger {
    private final ISRLogger logger;
    private final boolean color;

    public SRLogger(ISRLogger logger) {
        this(logger, false);
    }

    public void load(Path pluginFolder) {
        try {
            Path pluginConfigFile = pluginFolder.resolve("config.yml");
            if (Files.exists(pluginConfigFile, new LinkOption[0])) {
                YamlConfig pluginConfig = new YamlConfig(pluginConfigFile);
                pluginConfig.load();
                if (pluginConfig.getBoolean("Debug").booleanValue()) {
                    Config.DEBUG = true;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void debug(String message) {
        this.debug(SRLogLevel.INFO, message);
    }

    public void debug(String message, Throwable thrown) {
        this.debug(SRLogLevel.WARNING, message, thrown);
    }

    public void debug(Throwable thrown) {
        this.debug(SRLogLevel.WARNING, "Received error", thrown);
    }

    public void debug(SRLogLevel level, String message) {
        if (!Config.DEBUG) {
            return;
        }
        this.log(level, message);
    }

    public void debug(SRLogLevel level, String message, Throwable thrown) {
        if (!Config.DEBUG) {
            return;
        }
        this.log(level, message, thrown);
    }

    public void info(String message) {
        this.log(SRLogLevel.INFO, message);
    }

    public void info(String message, Throwable thrown) {
        this.log(SRLogLevel.INFO, message, thrown);
    }

    public void warning(String message) {
        this.log(SRLogLevel.WARNING, message);
    }

    public void warning(String message, Throwable thrown) {
        this.log(SRLogLevel.WARNING, message, thrown);
    }

    public void severe(String message) {
        this.log(SRLogLevel.SEVERE, message);
    }

    public void severe(String message, Throwable thrown) {
        this.log(SRLogLevel.SEVERE, message, thrown);
    }

    private void log(SRLogLevel level, String message) {
        this.logger.log(level, this.formatMessage(message));
    }

    private void log(SRLogLevel level, String message, Throwable thrown) {
        this.logger.log(level, this.formatMessage(message), thrown);
    }

    private String formatMessage(String message) {
        message = this.color ? "\u00a7e[\u00a72SkinsRestorer\u00a7e] \u00a7r" + message : message;
        message = message + "\u00a7r";
        message = ANSIConverter.convertToAnsi(message);
        return message;
    }

    public SRLogger(ISRLogger logger, boolean color) {
        this.logger = logger;
        this.color = color;
    }
}

